<?php
/**
 *
 * (c) Copyright Ascensio System SIA 2021
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

class OnlyofficeItemActionObserver extends HookObserver implements HookDocumentItemActionObserverInterface
{
    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct(
            "plugin/onlyoffice/lib/onlyofficePlugin.php",
            "onlyoffice"
        );
    }

    /**
     * Create a Onlyoffice edit tools when the Chamilo loads document items
     *
     * @param HookDocumentItemActionEventInterface $event - the hook event
     */
    public function notifyDocumentItemAction(HookDocumentItemActionEventInterface $event)
    {
        $data = $event->getEventData();

        if ($data["type"] === HOOK_EVENT_TYPE_PRE) {
            $data["actions"][] = OnlyofficeTools::getButtonEdit($data);
            return $data;
        }
    }
}
