{{ form }}

{% if session %}
    <h3 class="page-header">{{ session.name }}</h3>
    <div class="table-responsive">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>{{ 'OfficialCode'|get_lang }}</th>
                    <th>{{ 'CoachName'|get_lang }}</th>
                    <th>{{ 'TimeSpentOnThePlatform'|get_lang }}</th>
                    <th>{{ 'FirstLoginInPlatform'|get_lang }}</th>
                    <th>{{ 'LatestLoginInPlatform'|get_lang }}</th>

                    {% for course_code in courses %}
                        <th>{{ course_code }}</th>
                        <th>{{ 'NumberOfWorks'|get_lang }}</th>
                        <th>{{ 'LastWork'|get_lang }}</th>
                        <th>{{ 'TimeReportForCourseX'|get_lang|format(course_code) }}</th>
                    {% endfor %}
                </tr>
            </thead>
            <tbody>
                {% for user in users %}
                    <tr>
                        {% for data in user %}
                            <td>{{ data }}</td>
                        {% endfor %}
                    </tr>
                {% endfor %}
            </tbody>
        </table>
    </div>

    {% for row in data %}
        <div class="table-responsive">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>{{ 'OfficialCode'|get_lang }}</th>
                        <th>{{ 'Name'|get_lang }}</th>
                        <th>{{ 'TimeSpentOnThePlatform'|get_lang }}</th>
                        <th>{{ 'FirstLoginInPlatform'|get_lang }}</th>
                        <th>{{ 'LatestLoginInPlatform'|get_lang }}</th>

                        {% for course in row.courses %}
                            <th>{{ course.code }}</th>
                            <th>{{ 'NumberOfWorks'|get_lang }}</th>
                            <th>{{ 'LastWork'|get_lang }}</th>
                            <th>{{ 'TimeReportForCourseX'|get_lang|format(course_code) }}</th>
                        {% endfor %}
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ row.code }}</td>
                        <td>{{ row.complete_name }}</td>
                        <td>{{ row.time_in_platform }}</td>
                        <td>{{ row.first_connection }}</td>
                        <td>{{ row.last_connection }}</td>

                        {% for course in row.courses %}
                            <td>{{ course.number_of_students }}</td>
                            <td>{{ course.number_of_works }}</td>
                            <td>{{ course.last_work }}</td>
                            <td>{{ course.time_spent_of_course }}</td>
                        {% endfor %}
                    </tr>
                </tbody>
            </table>
        </div>
    {% endfor %}
{% endif %}
