/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.video;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.Arrays;

public final class VideoFrame
implements MovieTag {
    private static final String FORMAT = "VideoFrame: { identifier=%d; frameNumber=%d; data=%d}";
    private int identifier;
    private int frameNumber;
    private byte[] data;
    private transient int length;

    public VideoFrame(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        this.identifier = coder.readUnsignedShort();
        this.frameNumber = coder.readUnsignedShort();
        this.data = coder.readBytes(new byte[this.length - 4]);
    }

    public VideoFrame(int uid, int frame, byte[] videoData) {
        this.setIdentifier(uid);
        this.setFrameNumber(frame);
        this.setData(videoData);
    }

    public VideoFrame(VideoFrame object) {
        this.identifier = object.identifier;
        this.frameNumber = object.frameNumber;
        this.data = object.data;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameNumber(int number) {
        if (number < 1 || number > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, number);
        }
        this.frameNumber = number;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void setData(byte[] frameData) {
        if (frameData == null) {
            throw new IllegalArgumentException();
        }
        this.data = Arrays.copyOf(frameData, frameData.length);
    }

    @Override
    public VideoFrame copy() {
        return new VideoFrame(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.frameNumber, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 4 + this.data.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(3967);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xF40 | this.length);
        }
        coder.writeShort(this.identifier);
        coder.writeShort(this.frameNumber);
        coder.writeBytes(this.data);
    }
}

