/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.video;

import com.flagstone.transform.coder.Copyable;
import java.util.Arrays;

public final class ImageBlock
implements Copyable<ImageBlock> {
    private final transient int width;
    private final transient int height;
    private final transient byte[] block;

    public ImageBlock(int blockWidth, int blockHeight, byte[] pixels) {
        this.width = blockWidth;
        this.height = blockHeight;
        this.block = Arrays.copyOf(pixels, pixels.length);
    }

    public ImageBlock(ImageBlock object) {
        this.width = object.width;
        this.height = object.height;
        this.block = object.block;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getBlock() {
        return Arrays.copyOf(this.block, this.block.length);
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0 || this.block == null || this.block.length == 0;
    }

    @Override
    public ImageBlock copy() {
        return new ImageBlock(this);
    }
}

