/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.font;

import com.flagstone.transform.coder.BigDecoder;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.font.CharacterFormat;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeRecord;
import com.flagstone.transform.util.font.Font;
import com.flagstone.transform.util.font.FontDecoder;
import com.flagstone.transform.util.font.FontFace;
import com.flagstone.transform.util.font.FontProvider;
import com.flagstone.transform.util.font.TrueTypeGlyph;
import com.flagstone.transform.util.shape.Canvas;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public final class TTFDecoder
implements FontProvider,
FontDecoder {
    private static final int BYTES_TO_BITS = 3;
    private static final int SIGN_EXTEND = 24;
    private static final int OS_2 = 1330851634;
    private static final int HEAD = 1751474532;
    private static final int HHEA = 1751672161;
    private static final int MAXP = 1835104368;
    private static final int LOCA = 1819239265;
    private static final int CMAP = 1668112752;
    private static final int HMTX = 1752003704;
    private static final int NAME = 1851878757;
    private static final int GLYF = 1735162214;
    private static final int ITLF_SHORT = 0;
    private static final int WEIGHT_BOLD = 700;
    private static final int ON_CURVE = 1;
    private static final int X_SHORT = 2;
    private static final int Y_SHORT = 4;
    private static final int REPEAT_FLAG = 8;
    private static final int X_SAME = 16;
    private static final int Y_SAME = 32;
    private static final int X_POSITIVE = 16;
    private static final int Y_POSITIVE = 32;
    private static final int ARGS_ARE_WORDS = 1;
    private static final int ARGS_ARE_XY = 2;
    private static final int HAVE_SCALE = 8;
    private static final int HAVE_XYSCALE = 64;
    private static final int HAVE_2X2 = 128;
    private static final int HAS_MORE = 16;
    private transient String name;
    private transient boolean bold;
    private transient boolean italic;
    private transient CharacterFormat encoding;
    private transient float ascent;
    private transient float descent;
    private transient float leading;
    private transient int[] charToGlyph;
    private transient int[] glyphToChar;
    private transient TrueTypeGlyph[] glyphTable;
    private transient int glyphCount;
    private transient int missingGlyph;
    private transient char maxChar;
    private transient int scale = 1;
    private transient int metrics;
    private transient int glyphOffset;
    private transient int[] offsets;
    private final transient Map<Integer, TableEntry> table = new LinkedHashMap<Integer, TableEntry>();
    private final transient List<Font> fonts = new ArrayList<Font>();

    @Override
    public FontDecoder newDecoder() {
        return new TTFDecoder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file) throws IOException, DataFormatException {
        FileInputStream stream = new FileInputStream(file);
        try {
            this.read(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int contentLength = connection.getContentLength();
        if (contentLength < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        InputStream stream = connection.getInputStream();
        try {
            this.read(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Override
    public List<Font> getFonts() {
        return this.fonts;
    }

    public void read(InputStream stream) throws IOException {
        this.loadTables(stream);
        this.decodeTables();
        Font font = new Font();
        font.setFace(new FontFace(this.name, this.bold, this.italic));
        font.setEncoding(this.encoding);
        font.setAscent((int)this.ascent);
        font.setDescent((int)this.descent);
        font.setLeading((int)this.leading);
        font.setNumberOfGlyphs(this.glyphCount);
        font.setMissingGlyph(this.missingGlyph);
        font.setHighestChar(this.maxChar);
        for (int i = 0; i < this.glyphCount; ++i) {
            font.addGlyph((char)this.glyphToChar[i], this.glyphTable[i]);
        }
        this.fonts.add(font);
    }

    private void loadTables(InputStream stream) throws IOException {
        BigDecoder coder = new BigDecoder(stream);
        coder.mark();
        coder.readInt();
        int tableCount = coder.readUnsignedShort();
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        Object[] directory = new TableEntry[tableCount];
        for (int i = 0; i < tableCount; ++i) {
            directory[i] = new TableEntry();
            ((TableEntry)directory[i]).type = coder.readInt();
            coder.readInt();
            ((TableEntry)directory[i]).offset = coder.readInt();
            ((TableEntry)directory[i]).length = coder.readInt();
        }
        Arrays.sort(directory);
        for (Object entry : directory) {
            coder.skip(((TableEntry)entry).offset - coder.bytesRead());
            ((TableEntry)entry).setData(coder.readBytes(new byte[((TableEntry)entry).length]));
            this.table.put(((TableEntry)entry).type, (TableEntry)entry);
        }
    }

    private void decodeTables() throws IOException {
        this.decodeMAXP(this.table.get(1835104368));
        this.decodeOS2(this.table.get(1330851634));
        this.decodeHEAD(this.table.get(1751474532));
        this.decodeHHEA(this.table.get(1751672161));
        this.decodeNAME(this.table.get(1851878757));
        this.decodeLOCA(this.table.get(1819239265));
        this.decodeGlyphs(this.table.get(1735162214));
        this.decodeHMTX(this.table.get(1752003704));
        this.decodeCMAP(this.table.get(1668112752));
    }

    private void decodeHEAD(TableEntry entry) throws IOException {
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        byte[] date = new byte[8];
        coder.readInt();
        coder.readInt();
        coder.readInt();
        coder.readInt();
        coder.readUnsignedShort();
        this.scale = coder.readUnsignedShort() / 1024;
        if (this.scale == 0) {
            this.scale = 1;
        }
        coder.readBytes(date);
        coder.readBytes(date);
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        int flags = coder.readUnsignedShort();
        this.bold = (flags & 0x8000) != 0;
        this.italic = (flags & 0x400) != 0;
        coder.readUnsignedShort();
        coder.readShort();
        this.glyphOffset = coder.readShort();
        coder.readShort();
    }

    private void decodeHHEA(TableEntry entry) throws IOException {
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        coder.readInt();
        this.ascent = (float)coder.readShort() / (float)this.scale;
        this.descent = -((float)coder.readShort() / (float)this.scale);
        this.leading = (float)coder.readShort() / (float)this.scale;
        coder.readUnsignedShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        coder.readShort();
        this.metrics = coder.readUnsignedShort();
    }

    private void decodeOS2(TableEntry entry) throws IOException {
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        byte[] panose = new byte[10];
        int[] unicodeRange = new int[4];
        byte[] vendor = new byte[4];
        int version = coder.readUnsignedShort();
        coder.readShort();
        int weight = coder.readUnsignedShort();
        if (weight == 700) {
            this.bold = true;
        }
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readShort();
        coder.readBytes(panose);
        for (int i = 0; i < 4; ++i) {
            unicodeRange[i] = coder.readInt();
        }
        coder.readBytes(vendor);
        int flags = coder.readUnsignedShort();
        this.italic = (flags & 0x8000) != 0;
        this.bold = (flags & 0x400) != 0;
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        this.ascent = (float)coder.readUnsignedShort() / (float)this.scale;
        this.descent = -((float)coder.readUnsignedShort() / (float)this.scale);
        this.leading = (float)coder.readUnsignedShort() / (float)this.scale;
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        if (version > 0) {
            coder.readInt();
            coder.readInt();
            if (version > 1) {
                coder.readShort();
                coder.readShort();
                this.missingGlyph = coder.readUnsignedShort();
                coder.readUnsignedShort();
                coder.readUnsignedShort();
            }
        }
    }

    private void decodeNAME(TableEntry entry) throws IOException {
        int i;
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        coder.readUnsignedShort();
        int names = coder.readUnsignedShort();
        int tableOffset = coder.readUnsignedShort();
        NameEntry[] nameTable = new NameEntry[names];
        for (i = 0; i < names; ++i) {
            nameTable[i] = new NameEntry();
            nameTable[i].platform = coder.readUnsignedShort();
            nameTable[i].encoding = coder.readUnsignedShort();
            nameTable[i].language = coder.readUnsignedShort();
            nameTable[i].name = coder.readUnsignedShort();
            nameTable[i].length = coder.readUnsignedShort();
            nameTable[i].offset = coder.readUnsignedShort();
        }
        for (i = 0; i < names; ++i) {
            coder.reset();
            coder.skip(tableOffset + nameTable[i].offset);
            byte[] bytes = new byte[nameTable[i].length];
            coder.readBytes(bytes);
            String nameEncoding = "UTF-8";
            if (nameTable[i].platform == 0) {
                nameEncoding = "UTF-16";
            } else if (nameTable[i].platform == 1) {
                if (nameTable[i].encoding == 0 && nameTable[i].language == 0) {
                    nameEncoding = "ISO8859-1";
                }
            } else if (nameTable[i].platform == 3) {
                switch (nameTable[i].encoding) {
                    case 1: {
                        nameEncoding = "UTF-16";
                        break;
                    }
                    case 2: {
                        nameEncoding = "SJIS";
                        break;
                    }
                    case 4: {
                        nameEncoding = "Big5";
                        break;
                    }
                    default: {
                        nameEncoding = "UTF-8";
                    }
                }
            }
            try {
                if (nameTable[i].name != 1) continue;
                this.name = new String(bytes, nameEncoding);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.name = new String(bytes);
            }
        }
    }

    private void decodeMAXP(TableEntry entry) throws IOException {
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        float version = (float)coder.readInt() / 65536.0f;
        this.glyphCount = coder.readUnsignedShort();
        this.glyphTable = new TrueTypeGlyph[this.glyphCount];
        this.glyphToChar = new int[this.glyphCount];
        if (version == 1.0f) {
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
        }
    }

    private void decodeHMTX(TableEntry entry) throws IOException {
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        int index = 0;
        for (index = 0; index < this.metrics; ++index) {
            this.glyphTable[index].setAdvance(coder.readUnsignedShort() / this.scale);
            coder.readShort();
        }
        int advance = this.glyphTable[index - 1].getAdvance();
        while (index < this.glyphCount) {
            this.glyphTable[index++].setAdvance(advance);
        }
        while (index < this.glyphCount) {
            coder.readShort();
            ++index;
        }
    }

    private void decodeCMAP(TableEntry entry) throws IOException {
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        coder.readUnsignedShort();
        int numberOfTables = coder.readUnsignedShort();
        int offset = 0;
        int format = 0;
        for (int tableCount = 0; tableCount < numberOfTables; ++tableCount) {
            int platformId = coder.readUnsignedShort();
            int encodingId = coder.readUnsignedShort();
            offset = coder.readInt();
            coder.mark();
            if (platformId == 0) {
                this.encoding = CharacterFormat.UCS2;
            } else if (platformId == 1) {
                this.encoding = encodingId == 1 ? CharacterFormat.SJIS : CharacterFormat.ANSI;
            } else if (platformId == 3) {
                this.encoding = encodingId == 1 ? CharacterFormat.UCS2 : (encodingId == 2 ? CharacterFormat.SJIS : CharacterFormat.ANSI);
            }
            coder.move(offset);
            format = coder.readUnsignedShort();
            coder.readUnsignedShort();
            coder.readUnsignedShort();
            if (format == 0) {
                this.decodeSimpleCMAP(coder);
            } else if (format == 4) {
                this.decodeRangeCMAP(coder);
            } else {
                throw new IOException();
            }
            coder.reset();
        }
        this.encoding = CharacterFormat.SJIS;
    }

    private void decodeSimpleCMAP(BigDecoder coder) throws IOException {
        this.charToGlyph = new int[256];
        this.maxChar = (char)255;
        for (int index = 0; index < 256; ++index) {
            this.charToGlyph[index] = coder.readByte();
            this.glyphToChar[this.charToGlyph[index]] = index;
        }
    }

    private void decodeRangeCMAP(BigDecoder coder) throws IOException {
        int index;
        int segmentCount = coder.readUnsignedShort() / 2;
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        coder.readUnsignedShort();
        int[] startCount = new int[segmentCount];
        int[] endCount = new int[segmentCount];
        int[] delta = new int[segmentCount];
        int[] range = new int[segmentCount];
        int[] rangeAdr = new int[segmentCount];
        for (index = 0; index < segmentCount; ++index) {
            endCount[index] = coder.readUnsignedShort();
            if (endCount[index] <= this.maxChar) continue;
            this.maxChar = (char)endCount[index];
        }
        this.charToGlyph = new int[this.maxChar + '\u0001'];
        coder.readUnsignedShort();
        for (index = 0; index < segmentCount; ++index) {
            startCount[index] = coder.readUnsignedShort();
        }
        for (index = 0; index < segmentCount; ++index) {
            delta[index] = coder.readShort();
        }
        for (index = 0; index < segmentCount; ++index) {
            rangeAdr[index] = coder.mark();
            range[index] = coder.readShort();
            coder.unmark();
        }
        int glyphIndex = 0;
        int location = 0;
        for (int index2 = 0; index2 < segmentCount; ++index2) {
            int code = startCount[index2];
            while (code <= endCount[index2]) {
                if (range[index2] == 0) {
                    glyphIndex = (delta[index2] + code) % 65535;
                } else {
                    location = rangeAdr[index2] + range[index2] + (code - startCount[index2] << 1);
                    coder.move(location);
                    glyphIndex = coder.readUnsignedShort();
                    if (glyphIndex != 0) {
                        glyphIndex = (glyphIndex + delta[index2]) % 65535;
                    }
                }
                this.charToGlyph[code] = glyphIndex;
                this.glyphToChar[glyphIndex] = code++;
            }
        }
    }

    private void decodeLOCA(TableEntry entry) throws IOException {
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        this.offsets = new int[this.glyphCount];
        this.offsets[0] = this.glyphOffset == 0 ? coder.readUnsignedShort() * 2 << 3 : coder.readInt() << 3;
        for (int i = 1; i < this.glyphCount; ++i) {
            this.offsets[i] = this.glyphOffset == 0 ? coder.readUnsignedShort() * 2 << 3 : coder.readInt() << 3;
            if (this.offsets[i] != this.offsets[i - 1]) continue;
            this.offsets[i - 1] = 0;
        }
    }

    private void decodeGlyphs(TableEntry entry) throws IOException {
        int i;
        byte[] data = entry.getData();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        BigDecoder coder = new BigDecoder(stream, data.length);
        int numberOfContours = 0;
        for (i = 0; i < this.glyphCount; ++i) {
            coder.skip(this.offsets[i] >> 3);
            numberOfContours = coder.readShort();
            if (numberOfContours >= 0) {
                this.decodeSimpleGlyph(coder, i, numberOfContours);
            }
            coder.reset();
        }
        for (i = 0; i < this.glyphCount; ++i) {
            if (this.offsets[i] == 0) continue;
            coder.skip(this.offsets[i] >> 3);
            if (coder.readShort() == -1) {
                this.decodeCompositeGlyph(coder, i);
            }
            coder.reset();
        }
    }

    private void decodeSimpleGlyph(BigDecoder coder, int glyphIndex, int numberOfContours) throws IOException {
        int i;
        int xMin = coder.readShort() / this.scale;
        int yMin = coder.readShort() / this.scale;
        int xMax = coder.readShort() / this.scale;
        int yMax = coder.readShort() / this.scale;
        int[] endPtsOfContours = new int[numberOfContours];
        for (int i2 = 0; i2 < numberOfContours; ++i2) {
            endPtsOfContours[i2] = coder.readUnsignedShort();
        }
        int instructionCount = coder.readUnsignedShort();
        int[] instructions = new int[instructionCount];
        for (int i3 = 0; i3 < instructionCount; ++i3) {
            instructions[i3] = coder.readByte();
        }
        int numberOfPoints = numberOfContours == 0 ? 0 : endPtsOfContours[endPtsOfContours.length - 1] + 1;
        int[] flags = new int[numberOfPoints];
        int[] xCoordinates = new int[numberOfPoints];
        int[] yCoordinates = new int[numberOfPoints];
        boolean[] onCurve = new boolean[numberOfPoints];
        int repeatCount = 0;
        int repeatFlag = 0;
        for (int i4 = 0; i4 < numberOfPoints; ++i4) {
            if (repeatCount > 0) {
                flags[i4] = repeatFlag;
                --repeatCount;
            } else {
                flags[i4] = coder.readByte();
                if ((flags[i4] & 8) > 0) {
                    repeatCount = coder.readByte();
                    repeatFlag = flags[i4];
                }
            }
            onCurve[i4] = (flags[i4] & 1) > 0;
        }
        int last = 0;
        for (i = 0; i < numberOfPoints; ++i) {
            if ((flags[i] & 2) > 0) {
                if ((flags[i] & 0x10) > 0) {
                    xCoordinates[i] = last + coder.readByte();
                    last = xCoordinates[i];
                    continue;
                }
                xCoordinates[i] = last - coder.readByte();
                last = xCoordinates[i];
                continue;
            }
            if ((flags[i] & 0x10) > 0) {
                xCoordinates[i] = last;
                continue;
            }
            xCoordinates[i] = last + coder.readShort();
            last = xCoordinates[i];
        }
        last = 0;
        for (i = 0; i < numberOfPoints; ++i) {
            if ((flags[i] & 4) > 0) {
                if ((flags[i] & 0x20) > 0) {
                    yCoordinates[i] = last + coder.readByte();
                    last = yCoordinates[i];
                    continue;
                }
                yCoordinates[i] = last - coder.readByte();
                last = yCoordinates[i];
                continue;
            }
            if ((flags[i] & 0x20) > 0) {
                yCoordinates[i] = last;
                continue;
            }
            yCoordinates[i] = last + coder.readShort();
            last = yCoordinates[i];
        }
        Canvas path = new Canvas();
        boolean contourStart = true;
        boolean offPoint = false;
        int contour = 0;
        int xCoord = 0;
        int yCoord = 0;
        int prevX = 0;
        int prevY = 0;
        int initX = 0;
        int initY = 0;
        for (int i5 = 0; i5 < numberOfPoints; ++i5) {
            xCoord = xCoordinates[i5] / this.scale;
            yCoord = yCoordinates[i5] / this.scale;
            if (onCurve[i5]) {
                if (contourStart) {
                    path.moveForFont(xCoord, -yCoord);
                    contourStart = false;
                    initX = xCoord;
                    initY = yCoord;
                } else if (offPoint) {
                    path.curve(prevX, -prevY, xCoord, -yCoord);
                    offPoint = false;
                } else {
                    path.line(xCoord, -yCoord);
                }
            } else {
                if (offPoint) {
                    path.curve(prevX, -prevY, (xCoord + prevX) / 2, -(yCoord + prevY) / 2);
                }
                prevX = xCoord;
                prevY = yCoord;
                offPoint = true;
            }
            if (i5 != endPtsOfContours[contour]) continue;
            if (offPoint) {
                path.curve(xCoord, -yCoord, initX, -initY);
            } else {
                path.close();
            }
            contourStart = true;
            offPoint = false;
            prevX = 0;
            prevY = 0;
            ++contour;
        }
        this.glyphTable[glyphIndex] = new TrueTypeGlyph(path.getShape(), new Bounds(xMin, -yMax, xMax, -yMin), 0);
        this.glyphTable[glyphIndex].setCoordinates(xCoordinates, yCoordinates);
        this.glyphTable[glyphIndex].setOnCurve(onCurve);
        this.glyphTable[glyphIndex].setEnds(endPtsOfContours);
    }

    private void decodeCompositeGlyph(BigDecoder coder, int glyphIndex) throws IOException {
        Shape shape = new Shape(new ArrayList<ShapeRecord>());
        CoordTransform transform = null;
        int xMin = coder.readShort();
        int yMin = coder.readShort();
        int xMax = coder.readShort();
        int yMax = coder.readShort();
        TrueTypeGlyph points = null;
        int numberOfPoints = 0;
        int[] endPtsOfContours = null;
        int[] xCoordinates = null;
        int[] yCoordinates = null;
        boolean[] onCurve = null;
        int flags = 0;
        int sourceGlyph = 0;
        int xOffset = 0;
        int yOffset = 0;
        do {
            flags = coder.readUnsignedShort();
            sourceGlyph = coder.readUnsignedShort();
            if (sourceGlyph >= this.glyphTable.length || this.glyphTable[sourceGlyph] == null) {
                this.glyphTable[glyphIndex] = new TrueTypeGlyph(null, new Bounds(xMin, yMin, xMax, yMax), 0);
                return;
            }
            points = this.glyphTable[sourceGlyph];
            numberOfPoints = points.numberOfPoints();
            endPtsOfContours = new int[points.numberOfContours()];
            points.getEnd(endPtsOfContours);
            xCoordinates = new int[numberOfPoints];
            points.getXCoordinates(xCoordinates);
            yCoordinates = new int[numberOfPoints];
            points.getYCoordinates(yCoordinates);
            onCurve = new boolean[numberOfPoints];
            points.getCurve(onCurve);
            if ((flags & 1) == 0 && (flags & 2) == 0) {
                coder.readByte();
                coder.readByte();
                transform = CoordTransform.translate(0, 0);
            } else if ((flags & 1) == 0 && (flags & 2) > 0) {
                xOffset = coder.readByte() << 24 >> 24;
                yOffset = coder.readByte() << 24 >> 24;
                transform = CoordTransform.translate(xOffset, yOffset);
            } else if ((flags & 1) > 0 && (flags & 2) == 0) {
                coder.readUnsignedShort();
                coder.readUnsignedShort();
                transform = CoordTransform.translate(0, 0);
            } else {
                xOffset = coder.readShort();
                yOffset = coder.readShort();
                transform = CoordTransform.translate(xOffset, yOffset);
            }
            if ((flags & 8) > 0) {
                float scaleXY = (float)coder.readShort() / 16384.0f;
                transform = new CoordTransform(scaleXY, scaleXY, 0.0f, 0.0f, xOffset, yOffset);
            } else if ((flags & 0x40) > 0) {
                float scaleX = (float)coder.readShort() / 16384.0f;
                float scaleY = (float)coder.readShort() / 16384.0f;
                transform = new CoordTransform(scaleX, scaleY, 0.0f, 0.0f, xOffset, yOffset);
            } else if ((flags & 0x80) > 0) {
                float scaleX = (float)coder.readShort() / 16384.0f;
                float scale01 = (float)coder.readShort() / 16384.0f;
                float scale10 = (float)coder.readShort() / 16384.0f;
                float scaleY = (float)coder.readShort() / 16384.0f;
                transform = new CoordTransform(scaleX, scaleY, scale01, scale10, xOffset, yOffset);
            }
            float[][] matrix = transform.getMatrix();
            for (int i = 0; i < numberOfPoints; ++i) {
                float[][] result = CoordTransform.product(matrix, CoordTransform.translate(xCoordinates[i], yCoordinates[i]).getMatrix());
                xCoordinates[i] = (int)result[0][2];
                yCoordinates[i] = (int)result[1][2];
            }
            Canvas path = new Canvas();
            boolean contourStart = true;
            boolean offPoint = false;
            int contour = 0;
            int xCoord = 0;
            int yCoord = 0;
            int prevX = 0;
            int prevY = 0;
            int initX = 0;
            int initY = 0;
            for (int i = 0; i < numberOfPoints; ++i) {
                xCoord = xCoordinates[i] / this.scale;
                yCoord = yCoordinates[i] / this.scale;
                if (onCurve[i]) {
                    if (contourStart) {
                        path.moveForFont(xCoord, -yCoord);
                        contourStart = false;
                        initX = xCoord;
                        initY = yCoord;
                    } else if (offPoint) {
                        path.curve(prevX, -prevY, xCoord, -yCoord);
                        offPoint = false;
                    } else {
                        path.line(xCoord, -yCoord);
                    }
                } else {
                    if (offPoint) {
                        path.curve(prevX, -prevY, (xCoord + prevX) / 2, -(yCoord + prevY) / 2);
                    }
                    prevX = xCoord;
                    prevY = yCoord;
                    offPoint = true;
                }
                if (i != endPtsOfContours[contour]) continue;
                if (offPoint) {
                    path.curve(xCoord, -yCoord, initX, -initY);
                } else {
                    path.close();
                }
                contourStart = true;
                offPoint = false;
                prevX = 0;
                prevY = 0;
                ++contour;
            }
            shape.getObjects().addAll(path.getShape().getObjects());
        } while ((flags & 0x10) > 0);
        this.glyphTable[glyphIndex] = new TrueTypeGlyph(shape, new Bounds(xMin, yMin, xMax, yMax), 0);
        this.glyphTable[glyphIndex].setCoordinates(xCoordinates, yCoordinates);
        this.glyphTable[glyphIndex].setOnCurve(onCurve);
        this.glyphTable[glyphIndex].setEnds(endPtsOfContours);
    }

    private static final class NameEntry {
        private int platform;
        private int encoding;
        private int language;
        private int name;
        private int length;
        private int offset;

        protected NameEntry() {
        }
    }

    private static final class TableEntry
    implements Comparable<TableEntry> {
        private transient int type;
        private transient int offset;
        private transient int length;
        private transient byte[] data;

        private TableEntry() {
        }

        @Override
        public int compareTo(TableEntry obj) {
            int result = this.offset < obj.offset ? -1 : (this.offset == obj.offset ? 0 : 1);
            return result;
        }

        public boolean equals(Object object) {
            boolean result;
            if (object == null) {
                result = false;
            } else if (object == this) {
                result = true;
            } else if (object instanceof TableEntry) {
                TableEntry entry = (TableEntry)object;
                result = this.offset == entry.offset;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return this.offset * 31;
        }

        public void setData(byte[] bytes) {
            this.data = Arrays.copyOf(bytes, bytes.length);
        }

        public byte[] getData() {
            return Arrays.copyOf(this.data, this.data.length);
        }
    }
}

