/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.movieclip;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.ShowFrame;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineMovieClip
implements DefineTag {
    private static final String FORMAT = "DefineMovieClip: { identifier=%d; objects=%s}";
    private int identifier;
    private List<MovieTag> objects;
    private transient int frameCount;
    private transient int length;

    public DefineMovieClip(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        this.identifier = coder.readUnsignedShort();
        this.frameCount = coder.readUnsignedShort();
        this.objects = new ArrayList<MovieTag>();
        SWFFactory<MovieTag> decoder = context.getRegistry().getMovieDecoder();
        while (coder.scanUnsignedShort() >> 6 != 0) {
            decoder.getObject(this.objects, coder, context);
        }
        coder.readUnsignedShort();
    }

    public DefineMovieClip(int uid, List<MovieTag> list) {
        this.setIdentifier(uid);
        this.setObjects(list);
    }

    public DefineMovieClip(DefineMovieClip object) {
        this.identifier = object.identifier;
        this.objects = new ArrayList<MovieTag>(object.objects.size());
        for (MovieTag tag : object.objects) {
            this.objects.add((MovieTag)tag.copy());
        }
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public DefineMovieClip add(MovieTag obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.objects.add(obj);
        return this;
    }

    public List<MovieTag> getObjects() {
        return this.objects;
    }

    public void setObjects(List<MovieTag> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.objects = list;
    }

    @Override
    public DefineMovieClip copy() {
        return new DefineMovieClip(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.objects);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.frameCount = 0;
        this.length = 6;
        for (MovieTag object : this.objects) {
            this.length += object.prepareToEncode(context);
            if (!(object instanceof ShowFrame)) continue;
            ++this.frameCount;
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2559);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x9C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeShort(this.frameCount);
        for (MovieTag object : this.objects) {
            object.encode(coder, context);
        }
        coder.writeShort(0);
        coder.check(this.length);
        coder.unmark();
    }
}

