/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.linestyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.linestyle.LineStyle;
import java.io.IOException;

public final class MorphLineStyle
implements LineStyle {
    private static final String FORMAT = "MorphSolidLine: { startWidth=%d; endWidth=%d; startColor=%s; endColor=%s}";
    private int startWidth;
    private int endWidth;
    private Color startColor;
    private Color endColor;

    public MorphLineStyle(SWFDecoder coder, Context context) throws IOException {
        this.startWidth = coder.readUnsignedShort();
        this.endWidth = coder.readUnsignedShort();
        this.startColor = new Color(coder, context);
        this.endColor = new Color(coder, context);
    }

    public MorphLineStyle(int initialWidth, int finalWidth, Color initialColor, Color finalColor) {
        this.setStartWidth(initialWidth);
        this.setEndWidth(finalWidth);
        this.setStartColor(initialColor);
        this.setEndColor(finalColor);
    }

    public MorphLineStyle(MorphLineStyle object) {
        this.startWidth = object.startWidth;
        this.endWidth = object.endWidth;
        this.startColor = object.startColor;
        this.endColor = object.endColor;
    }

    public int getStartWidth() {
        return this.startWidth;
    }

    public int getEndWidth() {
        return this.endWidth;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setStartWidth(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.startWidth = aNumber;
    }

    public void setEndWidth(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.endWidth = aNumber;
    }

    public void setStartColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.startColor = aColor;
    }

    public void setEndColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.endColor = aColor;
    }

    @Override
    public MorphLineStyle copy() {
        return new MorphLineStyle(this);
    }

    public String toString() {
        return String.format(FORMAT, this.startWidth, this.endWidth, this.startColor, this.endColor);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 12;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(this.startWidth);
        coder.writeShort(this.endWidth);
        this.startColor.encode(coder, context);
        this.endColor.encode(coder, context);
    }
}

