/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.image;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.image.JPEGInfo;
import java.io.IOException;
import java.util.Arrays;

public final class DefineJPEGImage3
implements ImageTag {
    private static final String FORMAT = "DefineJPEGImage3: { identifier=%d;image=byte<%d> ...; alpha=byte<%d> ...}";
    private int identifier;
    private byte[] image;
    private byte[] alpha;
    private transient int length;
    private transient int width;
    private transient int height;

    public DefineJPEGImage3(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        int offset = coder.readInt();
        this.image = coder.readBytes(new byte[offset]);
        this.alpha = coder.readBytes(new byte[this.length - offset - 6]);
        this.decodeInfo();
        coder.check(this.length);
        coder.unmark();
    }

    public DefineJPEGImage3(int uid, byte[] img, byte[] transparency) {
        this.setIdentifier(uid);
        this.setImage(img);
        this.setAlpha(transparency);
    }

    public DefineJPEGImage3(DefineJPEGImage3 object) {
        this.identifier = object.identifier;
        this.width = object.width;
        this.height = object.height;
        this.image = object.image;
        this.alpha = object.alpha;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public byte[] getImage() {
        return Arrays.copyOf(this.image, this.image.length);
    }

    public byte[] getAlpha() {
        return Arrays.copyOf(this.alpha, this.alpha.length);
    }

    public void setImage(byte[] bytes) {
        this.image = Arrays.copyOf(bytes, bytes.length);
        this.decodeInfo();
    }

    public void setAlpha(byte[] bytes) {
        this.alpha = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public DefineJPEGImage3 copy() {
        return new DefineJPEGImage3(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.image.length, this.alpha.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 6;
        this.length += this.image.length;
        this.length += this.alpha.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2303);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x8C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeInt(this.image.length);
        coder.writeBytes(this.image);
        coder.writeBytes(this.alpha);
        coder.check(this.length);
        coder.unmark();
    }

    private void decodeInfo() {
        JPEGInfo info = new JPEGInfo();
        info.decode(this.image);
        this.width = info.getWidth();
        this.height = info.getHeight();
    }
}

