/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.image;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.image.JPEGInfo;
import java.io.IOException;
import java.util.Arrays;

public final class DefineJPEGImage2
implements ImageTag {
    private static final String FORMAT = "DefineJPEGImage2: { identifier=%d; image=byte<%d> ...}";
    private int identifier;
    private byte[] image;
    private transient int length;
    private transient int width;
    private transient int height;

    public DefineJPEGImage2(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.image = coder.readBytes(new byte[this.length - 2]);
        this.decodeInfo();
        coder.check(this.length);
        coder.unmark();
    }

    public DefineJPEGImage2(int uid, byte[] img) {
        this.setIdentifier(uid);
        this.setImage(img);
    }

    public DefineJPEGImage2(DefineJPEGImage2 object) {
        this.identifier = object.identifier;
        this.width = object.width;
        this.height = object.height;
        this.image = object.image;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public byte[] getImage() {
        return Arrays.copyOf(this.image, this.image.length);
    }

    public void setImage(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.image = Arrays.copyOf(bytes, bytes.length);
        this.decodeInfo();
    }

    @Override
    public DefineJPEGImage2 copy() {
        return new DefineJPEGImage2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.image.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2 + this.image.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1407);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x540 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeBytes(this.image);
        coder.check(this.length);
        coder.unmark();
    }

    private void decodeInfo() {
        JPEGInfo info = new JPEGInfo();
        info.decode(this.image);
        this.width = info.getWidth();
        this.height = info.getHeight();
    }
}

