/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.coder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

public final class BigDecoder {
    public static final int BUFFER_SIZE = 4096;
    private static final int BYTE_MASK = 255;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_BYTE = 8;
    private static final int BITS_TO_BYTES = 3;
    private static final int BYTES_TO_BITS = 3;
    private static final int TO_BYTE1 = 8;
    private static final int TO_BYTE2 = 16;
    private static final int TO_BYTE3 = 24;
    private final transient InputStream stream;
    private final transient byte[] buffer;
    private final transient Stack<Integer> locations;
    private transient int pos;
    private transient int index;
    private transient int offset;
    private transient int size;

    public BigDecoder(InputStream streamIn, int length) {
        this.stream = streamIn;
        this.buffer = new byte[length];
        this.locations = new Stack();
    }

    public BigDecoder(InputStream streamIn) {
        this.stream = streamIn;
        this.buffer = new byte[4096];
        this.locations = new Stack();
    }

    public void fill() throws IOException {
        int diff = this.size - this.index;
        this.pos += this.index;
        if (this.index < this.size) {
            for (int i = 0; i < diff; ++i) {
                this.buffer[i] = this.buffer[this.index++];
            }
        }
        int bytesRead = 0;
        int bytesToRead = this.buffer.length - diff;
        this.index = diff;
        this.size = diff;
        do {
            if ((bytesRead = this.stream.read(this.buffer, this.index, bytesToRead)) == -1) {
                bytesToRead = 0;
                continue;
            }
            this.index += bytesRead;
            this.size += bytesRead;
            bytesToRead -= bytesRead;
        } while (bytesToRead > 0);
        this.index = 0;
    }

    public int mark() {
        return this.locations.push(this.pos + this.index);
    }

    public void unmark() {
        this.locations.pop();
    }

    public void reset() throws IOException {
        int location = this.locations.isEmpty() ? 0 : this.locations.peek();
        if (location - this.pos < 0) {
            throw new IOException();
        }
        this.index = location - this.pos;
    }

    public void move(int location) throws IOException {
        if (this.size - this.index == 0) {
            this.fill();
        }
        if (location < 0 || location > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.index = location;
        this.offset = 0;
    }

    public int bytesRead() {
        return this.pos + this.index - this.locations.peek();
    }

    public void alignToByte() {
        if (this.offset > 0) {
            ++this.index;
            this.offset = 0;
        }
    }

    public void skip(int count) throws IOException {
        if (this.size - this.index == 0) {
            this.fill();
        }
        if (count < this.size - this.index) {
            this.index += count;
        } else {
            int toSkip = count;
            while (toSkip > 0) {
                int diff = this.size - this.index;
                if (toSkip <= diff) {
                    this.index += toSkip;
                    toSkip = 0;
                    continue;
                }
                this.index += diff;
                toSkip -= diff;
                this.fill();
                if (this.size - this.index != 0) continue;
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public boolean eof() throws IOException {
        if (this.size - this.index == 0) {
            this.fill();
        }
        return this.size - this.index == 0;
    }

    public int readBits(int numberOfBits, boolean signed) throws IOException {
        int pointer = (this.index << 3) + this.offset;
        if ((this.size << 3) - pointer < numberOfBits) {
            this.fill();
            pointer = (this.index << 3) + this.offset;
        }
        int value = 0;
        if (numberOfBits > 0) {
            if (pointer + numberOfBits > this.size << 3) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 32; i > 0 && this.index < this.buffer.length; i -= 8) {
                value |= (this.buffer[this.index++] & 0xFF) << i - 8;
            }
            value <<= this.offset;
            value = signed ? (value >>= 32 - numberOfBits) : (value >>>= 32 - numberOfBits);
            this.index = (pointer += numberOfBits) >>> 3;
            this.offset = pointer & 7;
        }
        return value;
    }

    public int readByte() throws IOException {
        if (this.size - this.index < 1) {
            this.fill();
        }
        if (this.index + 1 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public byte[] readBytes(byte[] bytes) throws IOException {
        int wanted = bytes.length;
        int dest = 0;
        int read = 0;
        while (read < wanted) {
            int available = this.size - this.index;
            int remaining = wanted - read;
            if (available > remaining) {
                available = remaining;
            }
            System.arraycopy(this.buffer, this.index, bytes, dest, available);
            this.index += available;
            dest += available;
            if ((read += available) >= wanted || this.index != this.size) continue;
            this.fill();
        }
        return bytes;
    }

    public byte[] readBytes(byte[] bytes, int start, int length) throws IOException {
        int wanted = length;
        int dest = start;
        int read = 0;
        while (read < wanted) {
            int available = this.size - this.index;
            int remaining = wanted - read;
            if (available > remaining) {
                available = remaining;
            }
            System.arraycopy(this.buffer, this.index, bytes, dest, available);
            read += available;
            this.index += available;
            dest += available;
            if (this.index != this.size) continue;
            this.fill();
        }
        return bytes;
    }

    public int readUnsignedShort() throws IOException {
        if (this.size - this.index < 2) {
            this.fill();
        }
        if (this.index + 2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = (this.buffer[this.index++] & 0xFF) << 8;
        return value |= this.buffer[this.index++] & 0xFF;
    }

    public int readShort() throws IOException {
        if (this.size - this.index < 2) {
            this.fill();
        }
        if (this.index + 2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.buffer[this.index++] << 8;
        return value |= this.buffer[this.index++] & 0xFF;
    }

    public int scanInt() throws IOException {
        if (this.size - this.index < 4) {
            this.fill();
        }
        if (this.index + 4 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int addr = this.index;
        int value = (this.buffer[addr++] & 0xFF) << 24;
        value |= (this.buffer[addr++] & 0xFF) << 16;
        value |= (this.buffer[addr++] & 0xFF) << 8;
        return value |= this.buffer[addr] & 0xFF;
    }

    public int readInt() throws IOException {
        if (this.size - this.index < 2) {
            this.fill();
        }
        if (this.index + 4 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = (this.buffer[this.index++] & 0xFF) << 24;
        value |= (this.buffer[this.index++] & 0xFF) << 16;
        value |= (this.buffer[this.index++] & 0xFF) << 8;
        return value |= this.buffer[this.index++] & 0xFF;
    }
}

