/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.button;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.action.Action;
import com.flagstone.transform.action.ActionData;
import com.flagstone.transform.button.ButtonShape;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineButton
implements DefineTag {
    private static final String FORMAT = "DefineButton: { identifier=%d; buttonRecords=%s; actions=%s}";
    private int identifier;
    private List<ButtonShape> shapes;
    private List<Action> actions;
    private transient int length;

    public DefineButton(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.shapes = new ArrayList<ButtonShape>();
        while (coder.scanByte() != 0) {
            this.shapes.add(new ButtonShape(coder, context));
        }
        coder.readByte();
        this.actions = new ArrayList<Action>();
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        if (decoder == null) {
            this.actions.add(new ActionData(coder.readBytes(new byte[this.length - coder.bytesRead()])));
        } else {
            while (coder.bytesRead() < this.length) {
                decoder.getObject(this.actions, coder, context);
            }
        }
        coder.check(this.length);
        coder.unmark();
    }

    public DefineButton(int uid, List<ButtonShape> buttons, List<Action> script) {
        this.setIdentifier(uid);
        this.setShapes(buttons);
        this.setActions(script);
    }

    public DefineButton(DefineButton object) {
        this.identifier = object.identifier;
        this.shapes = new ArrayList<ButtonShape>(object.shapes.size());
        for (ButtonShape shape : object.shapes) {
            this.shapes.add(shape.copy());
        }
        this.actions = new ArrayList<Action>(object.actions);
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public DefineButton add(ButtonShape obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(obj);
        return this;
    }

    public DefineButton add(Action obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.actions.add(obj);
        return this;
    }

    public List<ButtonShape> getShapes() {
        return this.shapes;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setShapes(List<ButtonShape> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.shapes = list;
    }

    public void setActions(List<Action> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.actions = list;
    }

    @Override
    public DefineButton copy() {
        return new DefineButton(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.shapes, this.actions);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2;
        for (ButtonShape shape : this.shapes) {
            this.length += shape.prepareToEncode(context);
        }
        ++this.length;
        for (Action action : this.actions) {
            this.length += action.prepareToEncode(context);
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(511);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        for (ButtonShape shape : this.shapes) {
            shape.encode(coder, context);
        }
        coder.writeByte(0);
        for (Action action : this.actions) {
            action.encode(coder, context);
        }
        coder.check(this.length);
        coder.unmark();
    }
}

