/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ExceptionHandler
implements Action {
    private static final String FORMAT = "ExceptionHandler: { variable=%s; register=%d try=%s; catch=%s; final=%s}";
    private static final int VARIABLE_MASK = 4;
    private static final int FINAL_MASK = 2;
    private static final int CATCH_MASK = 1;
    private static final int EMPTY_LENGTH = 8;
    private static final int HIGHEST_REGISTER = 255;
    private final transient int register;
    private final transient String variable;
    private final transient List<Action> tryActions;
    private final transient List<Action> catchActions;
    private final transient List<Action> finalActions;
    private transient int length;
    private transient int tryLength;
    private transient int catchLength;
    private transient int finalLength;

    public ExceptionHandler(Builder builder) {
        this.register = builder.register;
        this.variable = builder.variable;
        this.tryActions = new ArrayList<Action>(builder.tryActions);
        this.catchActions = new ArrayList<Action>(builder.catchActions);
        this.finalActions = new ArrayList<Action>(builder.finalActions);
    }

    public ExceptionHandler(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort();
        int flags = coder.readByte();
        boolean containsVariable = (flags & 4) >> 2 == 1;
        boolean containsFinal = (flags & 2) >> 1 == 1;
        boolean containsCatch = (flags & 1) == 1;
        this.tryLength = coder.readUnsignedShort();
        this.catchLength = coder.readUnsignedShort();
        this.finalLength = coder.readUnsignedShort();
        if (this.length == 8) {
            this.length += this.tryLength;
            this.length += this.catchLength;
            this.length += this.finalLength;
        }
        if (containsVariable) {
            this.variable = coder.readString();
            this.register = 0;
        } else {
            this.variable = "";
            this.register = coder.readByte();
        }
        this.tryActions = new ArrayList<Action>();
        this.catchActions = new ArrayList<Action>();
        this.finalActions = new ArrayList<Action>();
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        coder.mark();
        while (coder.bytesRead() < this.tryLength) {
            decoder.getObject(this.tryActions, coder, context);
        }
        coder.unmark();
        if (containsCatch) {
            coder.mark();
            while (coder.bytesRead() < this.catchLength) {
                decoder.getObject(this.catchActions, coder, context);
            }
            coder.unmark();
        }
        if (containsFinal) {
            coder.mark();
            while (coder.bytesRead() < this.finalLength) {
                decoder.getObject(this.finalActions, coder, context);
            }
            coder.unmark();
        }
    }

    public ExceptionHandler(String name, List<Action> tryArray, List<Action> catchArray, List<Action> finallyArray) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.variable = name;
        this.register = 0;
        if (tryArray == null) {
            throw new IllegalArgumentException();
        }
        this.tryActions = tryArray;
        if (catchArray == null) {
            throw new IllegalArgumentException();
        }
        this.catchActions = catchArray;
        if (finallyArray == null) {
            throw new IllegalArgumentException();
        }
        this.finalActions = finallyArray;
    }

    public ExceptionHandler(int index, List<Action> tryArray, List<Action> catchArray, List<Action> finallyArray) {
        if (index < 0 || index > 255) {
            throw new IllegalArgumentRangeException(0, 255, index);
        }
        this.variable = "";
        this.register = index;
        if (tryArray == null) {
            throw new IllegalArgumentException();
        }
        this.tryActions = tryArray;
        if (catchArray == null) {
            throw new IllegalArgumentException();
        }
        this.catchActions = catchArray;
        if (finallyArray == null) {
            throw new IllegalArgumentException();
        }
        this.finalActions = finallyArray;
    }

    public ExceptionHandler(ExceptionHandler object) {
        this.variable = object.variable;
        this.register = object.register;
        this.tryActions = new ArrayList<Action>(object.tryActions);
        this.catchActions = new ArrayList<Action>(object.catchActions);
        this.finalActions = new ArrayList<Action>(object.finalActions);
    }

    public String getVariable() {
        return this.variable;
    }

    public int getRegister() {
        return this.register;
    }

    public List<Action> getTryActions() {
        return new ArrayList<Action>(this.tryActions);
    }

    public List<Action> getCatchActions() {
        return new ArrayList<Action>(this.catchActions);
    }

    public List<Action> getFinalActions() {
        return new ArrayList<Action>(this.finalActions);
    }

    @Override
    public ExceptionHandler copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.variable, this.register, this.tryActions, this.catchActions, this.finalActions);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 8;
        if (this.register == 0) {
            this.length += context.strlen(this.variable) - 1;
        }
        this.tryLength = 0;
        this.catchLength = 0;
        this.finalLength = 0;
        for (Action action : this.tryActions) {
            this.tryLength += action.prepareToEncode(context);
        }
        for (Action action : this.catchActions) {
            this.catchLength += action.prepareToEncode(context);
        }
        for (Action action : this.finalActions) {
            this.finalLength += action.prepareToEncode(context);
        }
        this.length += this.tryLength;
        this.length += this.catchLength;
        this.length += this.finalLength;
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(143);
        coder.writeShort(this.length);
        int flags = 0;
        if (this.register == 0) {
            flags |= 4;
        }
        if (this.finalLength > 0) {
            flags |= 2;
        }
        if (this.catchLength > 0) {
            flags |= 1;
        }
        coder.writeByte(flags);
        coder.writeShort(this.tryLength);
        coder.writeShort(this.catchLength);
        coder.writeShort(this.finalLength);
        if (this.register == 0) {
            coder.writeString(this.variable);
        } else {
            coder.writeByte(this.register);
        }
        for (Action action : this.tryActions) {
            action.encode(coder, context);
        }
        for (Action action : this.catchActions) {
            action.encode(coder, context);
        }
        for (Action action : this.finalActions) {
            action.encode(coder, context);
        }
    }

    public static final class Builder {
        private transient int register;
        private transient String variable;
        private final transient List<Action> tryActions = new ArrayList<Action>();
        private final transient List<Action> catchActions = new ArrayList<Action>();
        private final transient List<Action> finalActions = new ArrayList<Action>();

        public Builder setRegister(int index) {
            if (index < 0 || index > 255) {
                throw new IllegalArgumentRangeException(0, 255, index);
            }
            this.variable = "";
            this.register = index;
            return this;
        }

        public Builder setVariable(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.variable = name;
            this.register = 0;
            return this;
        }

        public Builder addToTry(Action action) {
            if (action == null) {
                throw new IllegalArgumentException();
            }
            this.tryActions.add(action);
            return this;
        }

        public Builder addToCatch(Action action) {
            if (action == null) {
                throw new IllegalArgumentException();
            }
            this.catchActions.add(action);
            return this;
        }

        public Builder addToFinal(Action action) {
            if (action == null) {
                throw new IllegalArgumentException();
            }
            this.finalActions.add(action);
            return this;
        }

        public ExceptionHandler build() {
            return new ExceptionHandler(this);
        }
    }
}

