/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.Arrays;

public final class MovieObject
implements MovieTag {
    private static final String FORMAT = "MovieObject: { type=%d; data=byte<%d> ...}";
    private final transient int type;
    private final transient byte[] data;
    private transient int length;

    public MovieObject(SWFDecoder coder) throws IOException {
        this.type = coder.scanUnsignedShort() >>> 6;
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        this.data = coder.readBytes(new byte[this.length]);
    }

    public MovieObject(int aType, byte[] bytes) {
        this.type = aType;
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.data = Arrays.copyOf(bytes, bytes.length);
    }

    public MovieObject(MovieObject object) {
        this.type = object.type;
        this.data = object.data;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public MovieObject copy() {
        return new MovieObject(this);
    }

    public String toString() {
        return String.format(FORMAT, this.type, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = this.data.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(this.type << 6 | 0x3F);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(this.type << 6 | this.length);
        }
        coder.writeBytes(this.data);
    }
}

