/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import java.io.IOException;

public final class Background
implements MovieTag {
    private static final String FORMAT = "Background: { color=%s}";
    private Color color;

    public Background(SWFDecoder coder, Context context) throws IOException {
        int length = coder.readUnsignedShort() & 0x3F;
        if (length == 63) {
            length = coder.readInt();
        }
        coder.mark();
        this.color = new Color(coder, context);
        coder.check(length);
        coder.unmark();
    }

    public Background(Color aColor) {
        this.setColor(aColor);
    }

    public Background(Background object) {
        this.color = object.color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.color = aColor;
    }

    @Override
    public Background copy() {
        return new Background(this);
    }

    public String toString() {
        return String.format(FORMAT, this.color.toString());
    }

    @Override
    public int prepareToEncode(Context context) {
        return 5;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(579);
        this.color.encode(coder, context);
    }
}

